
#devtools::install_github("Schmidtpk/PointFore")

library(PointFore)
library(ggplot2)
library(reshape2)

#creating data with EKT gdp
gdp_EKT <- function(n=500, theta=c(1,0.5,0.5))
{
  W1 <- rnorm(n, mean = 1, sd = 1)
  W2 <- rnorm(n, mean = -1, sd = 1)
  W <- cbind(1,W1,W2)


  # Chi^2-distributed errors
  DoF <- 5
  u <- 2*rchisq(n, DoF, ncp = 0)
  Y <- W %*% theta + u

  # True mean and median forecasts
  FC_mean <- W %*% theta + 2*DoF
  FC_median <- W %*% theta + 2*qchisq(0.5, DoF, ncp = 0)

  return(data.frame(Y=Y, median=FC_median, mean=FC_mean, t=1:length(Y)))
}

dat <- gdp_EKT(n=1000)


ggplot(melt(gdp_EKT(n=100),id.vars = c("t")))+
  geom_line(aes(x=t, y=value,color=variable))

ggplot(gdp_EKT(n=1000))+
  geom_histogram(aes(x=Y-mean))



#defining identification function for convex combination of mean and median
#estimate.functional requires this as parameter
iden_convex <- function(x,y,stateVariable,theta,model,...)
{
  theta *(x-y) + (1-theta)*10*sign(x - y)
}


#one example


#median "works"
dat <- gdp_EKT()
res <- estimate.functional(iden.fct = iden_convex,
                    theta0 = c(.5),
                    lower=0,upper=1,
                    Y= dat$Y,
                    X= dat$median)
summary(res)


# mean doesnt "work"
res <- estimate.functional(iden.fct = iden_convex,
                           theta0 = c(.5),
                           lower=0,upper=1,
                           Y= dat$Y,
                           X= dat$mean)
summary(res)


MCS_mean_median <- function(n=500, MC_n= 10,...)
{
  res <- data.frame(theta_mean=numeric(MC_n), theta_median=numeric(MC_n))

  for(i in 1:MC_n)
  {
    dat <- gdp_EKT(n=n)

    suppressMessages(
    res_mean <- estimate.functional(iden.fct = iden_convex,
                               theta0 = c(.5),
                               lower=0,upper=1,
                               Y= dat$Y,
                               X= dat$mean,...))

    suppressMessages(
    res_med <- estimate.functional(iden.fct = iden_convex,
                               theta0 = c(.5),
                               lower=0,upper=1,
                               Y= dat$Y,
                               X= dat$median,...))


    res[i,]<-c(res_mean$gmm$coefficients,res_med$gmm$coefficients)
  }

  res
}

res <- MCS_mean_median()
ggplot(melt(res))+geom_density(aes(x=value,color=variable))+xlim(c(0,1))


res <- MCS_mean_median(n=2000,MC_n = 2)
ggplot(melt(res))+geom_density(aes(x=value,color=variable))+xlim(c(0,1))


res <- MCS_mean_median(instruments = matrix(rep(1,500)))
ggplot(melt(res))+geom_density(aes(x=value,color=variable))+xlim(c(0,1))


res <- MCS_mean_median(instruments = c("lag(X-Y)"))
ggplot(melt(res))+geom_density(aes(x=value,color=variable))+xlim(c(0,1))


res <- MCS_mean_median(instruments = c("sign(lag(X-Y))"))
ggplot(melt(res))+geom_density(aes(x=value,color=variable))+xlim(c(0,1))





